/* RSA-Angriff C++.cpp : 
 * Benchmarkversion testet Laufzeitverhalten primitiver Datentypen.
 *  - Konsolenprogramm
 *  - Auswahl zwischen bitorientierter Routine mit aufwndiger Rekursion DoPrim2() 
 *    und BruteForce-Routine DoPrimBruteForce() schlicht durch Auskommentieren in main()
 *  - zu zerlegende Zahl als BigNumber definiert. 
 *
 *  Anmerkung: DoPrimBruteForce() findet auch kleine Primfaktoren, 
 *             DoPrim2() ignoriert diese, da RSA-Paare immer groe Primfaktoren haben 
 *             (thats a bug, but also a feature)
*/

#include "stdafx.h"
#include "iostream.h"
#include "Math.h"
#include "Time.h"
#include "atltime.h"

const __int64 BigNumber = 34571237124234713L;         // 2 Minuten 
__int64 UBound;
__int64 z;   // enthlt die zu zerlegende Zahl

// Hilfsfunktion zur Ausgabe von __int64-Werten via cout
char* ui64tos(char* buf, __int64 i64)
{
	sprintf(buf,"%I64u", i64);
	return buf;
}

static void DoPrimBruteForce(__int64 NumberToCrunch)
{
	__int64 i; 
	for (i = 3; i < sqrt(NumberToCrunch); i+=2)
	{
		if(NumberToCrunch % i == 0)
		{
			__int64 j = NumberToCrunch / i;
			char buf0[32], buf1[32], buf2[32];
			cout << ui64tos(buf0, i) << " * " << ui64tos(buf1,j) << " = " << ui64tos(buf2,NumberToCrunch) << "\n";
		};
	}
}


void Prim(
	int n,   // Bitmaske bis m-te Stelle, also 2^m - 1
    int m,   // Stelle (Zweierpotenz)
    __int64 i,  // 1. Kandidat fr Primzahl
    __int64 j,  // 2. Kandidat fr Primzahl
    __int64 res) // Bisher auf m Stellen synthetisiertes Produkt
{
	__int64 product = i * j;   

     // Rekursion bricht ab, wenn
     //   - 1. Kandidat grer als Wurzel der Zahl
     //   - Produkt zu gro
     //   - m wegen berlauf negativ wird
    if ( i < UBound && product < z && m > 0)
    {
		__int64 z0 = z & n;   // Ausfiltern der relevanten Stellen
        int m1 = m<<1;     // nchste Stelle
        int n1 = n|m1;     // Bitmaske erweitern

       // Tiefensuche rekursiv!
       // Es gibt vier mgliche Flle, je zwei pro Kandidat
       // zwei davon gehen in die Rekursion
       // relevant sind nur m Stellen

		if ((res & n) == z0)        // +0, +0 (i, j unverndert)
			Prim(n1, m1, i, j, res);

		__int64 im = i|m;     // m-tes Bit der Kandidaten setzen
		__int64 jm = j|m;
		// Testen ob die letzten m Stellen des Kandidatenprodukts stimmen
		if (((res = im * j) & n) == z0)     // +1, +0 (m-tes Bit von i gesetzt)
			Prim(n1, m1, im, j, res);                  
		if ( ((res = i * jm) & n) == z0)    // +0, +1 (m-tes Bit von j gesetzt)
			Prim(n1, m1, i, jm, res);
		if ( ( (res = im * jm) & n) == z0)  // +1, +1 (m-tes Bit von i,j gesetzt)
			Prim(n1, m1, im, jm, res);            
	}
	else  // Rekursion bricht ab. Stimmt das Produkt etwa?
		if (i < UBound && product == z)                
		{
			char buf0[32], buf1[32], buf2[32];
			cout << ui64tos(buf0, i) << " * " << ui64tos(buf1,j) << " = " << ui64tos(buf2,z) << "\n";
			return;
		}
}

void DoPrim2(__int64 NumberToCrunch)
   {
     z = NumberToCrunch;
     UBound = (__int64) sqrt(z);    // Wurzelkriterium
     Prim(3, 2, 1, 1, 1);                    // Start der Rekursion
   }


int _tmain(int argc, _TCHAR* argv[])
{
	char buf[32]; 
	cout << "C++: Zerlege " << ui64tos(buf, BigNumber) << "\n";

	CTime start = CTime::GetCurrentTime();
    if ((argc == 1)  || (strcmp(argv[1], "-R") != 0))
	{ 
		cout << "Brute Force (Aufruf mit -R = rekursives Verfahren)\n";
		cout.flush(); 
		DoPrimBruteForce(BigNumber);
	}
    else
	{
      cout << "Rekursiver Ansatz (Aufruf ohne -R = Brute Force)\n";
	  cout.flush(); 
	  DoPrim2(BigNumber);
	}

	CTime end = CTime::GetCurrentTime();
	CTimeSpan diff = end - start; 
	cout << diff.GetMinutes() << " Min " << diff.GetSeconds() << " Sec\n"; 
	cout << "Press Enter";
	char a[10]; 
	cin.getline(a,8); 
	return 0;
}

